function [x,data,k] = Gradient_Descent(objective,Q,h,x0)

% Parameters
MAXITER = 100; %maximum number of iterations

alpha = 0.8;    % step size

xk = x0;

% save iterate information
data    = [];
data.x0 = x0;
data.x  = []; % iterates
data.d  = []; % search directions

% print the header
printIter();

tic
for k = 1:MAXITER
    
    % compute function and gradient
    [f_k,g_k,~] = objective(xk);

    
    % compute search direction (just opposite of the gradient)
    d_k = -g_k;
    
    
    % update the iterate
    xk1 = xk+alpha*d_k;
    

    % record the iterates
    if nargout >= 2
        data.x = [data.x,xk];
        data.d = [data.d,d_k];
    end
    
    % update iterate for next iteration
    xk = xk1;
    
    % print progress
    printIter(k, f_k, norm(d_k), alpha, toc);
    
end

%final point 
x = xk;

end


function printIter(iter, f_k, d_k_norm, alpha_k, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '  k        f        ||d||        alpha       CPU (s)';

% print algorithm output header
fprintf('\nBeginning gradient descent ...\n')
fprintf('%s\n%s\n%s\n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e  % .4e   % .5f\n',iter, f_k, d_k_norm, alpha_k, CPUtime);



end
